/// @file logger.cpp
///
/// @brief Implements the operator<< for Log based classes
///
/// @component Uspi/DeviceDetector
///
/// @author F.Berat / ADITG/SWG / fberat@de.adit-jv.com
///
/// @copyright (c) 2016 Advanced Driver Information Technology.
/// This code is developed by Advanced Driver Information Technology.
/// Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
/// All rights reserved.
///
/// @see Log DltLog SyslogLogger

#include <iostream>
#include <string>

#include "logger.h"

namespace adit {
namespace uspi {

/// @brief Stores the log priority gathered from the stream.
/// @param os The stream to consider
/// @param log_priority The priority to store
std::ostream& operator<< (std::ostream& os, const LogPriority& log_priority)
{
    static_cast<Log *>(os.rdbuf())->mPriority = log_priority;

    return os;
}

} // namespace uspi
} // namespace adit
